% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefficients.R
\name{short_icc}
\alias{short_icc}
\title{Calculate Intraclass Correlation Coefficient (ICC)}
\usage{
short_icc(
  x,
  y,
  type = c("ICC1", "ICC2", "ICC3", "ICC1k", "ICC2k", "ICC3k"),
  ...
)
}
\arguments{
\item{x}{(vector) a numeric vector}

\item{y}{(vector) a numeric vector with compatible dimensions to x}

\item{type}{(character) type of ICC to calculate, see \code{\link[psych]{ICC}}}

\item{...}{Arguments passed to \code{\link[psych]{ICC}}}
}
\value{
(numeric) Value of ICC coefficient
}
\description{
Wrapper for ICCs calculated via \code{\link[psych]{ICC}}. If x or y have 
less than two elements, NA is returned.
}
\examples{
# Generate two variables with different means, variances and a correlation of about 0.5
library(MASS)
vars = mvrnorm(30, mu = c(0, 2), Sigma = matrix(c(5, 2, 2, 3), ncol = 2), empirical = TRUE)
# Calculate ICC1
short_icc(vars[,1], vars[,2], type = "ICC1", lmer = FALSE)
}
\seealso{
Other splithalfr coefficients: 
\code{\link{angoff_feldt}()},
\code{\link{assmd}()},
\code{\link{flanagan_rulon}()},
\code{\link{sdregi}()},
\code{\link{spearman_brown}()}
}
\concept{splithalfr coefficients}
