% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbmokcv.R
\name{gbmokcv}
\alias{gbmokcv}
\title{Cross validation, n-fold for the hybrid method of generalized boosted regression modeling and ordinary kriging (gbmok)}
\usage{
gbmokcv(longlat, trainx, trainy, var.monotone = rep(0, ncol(trainx)),
  family = "gaussian", n.trees = 3000, learning.rate = 0.001,
  interaction.depth = 2, bag.fraction = 0.5, train.fraction = 1,
  n.minobsinnode = 10, cv.fold = 10, weights = rep(1, nrow(trainx)),
  keep.data = FALSE, verbose = TRUE, nmax = 12, vgm.args = ("Sph"),
  block = 0, predacc = "VEcv", n.cores = 6, ...)
}
\arguments{
\item{longlat}{a dataframe contains longitude and latitude of validation
samples.}

\item{trainx}{a dataframe or matrix contains columns of predictive variables.}

\item{trainy}{a vector of response, must have length equal to the number of
rows in trainx.}

\item{var.monotone}{an optional vector, the same length as the number of
predictors, indicating which variables have a monotone increasing (+1),
decreasing (-1), or arbitrary (0) relationship with the outcome. By default,
a vector of 0 is used.}

\item{family}{either a character string specifying the name of the distribution to
use or a list with a component name specifying the distribution and any
additional parameters needed. See gbm for details. By default, "gaussian" is
used.}

\item{n.trees}{the total number of trees to fit. This is equivalent to the
number of iterations and the number of basis functions in the additive
expansion. By default, 3000 is used.}

\item{learning.rate}{a shrinkage parameter applied to each tree in the
expansion. Also known as step-size reduction.}

\item{interaction.depth}{the maximum depth of variable interactions.
1 implies an additive model, 2 implies a model with up to 2-way
interactions, etc. By default, 2 is used.}

\item{bag.fraction}{the fraction of the training set observations randomly
selected to propose the next tree in the expansion. By default, 0.5 is used.}

\item{train.fraction}{The first train.fraction * nrows(data) observations
are used to fit the gbm and the remainder are used for computing
out-of-sample estimates of the loss function.}

\item{n.minobsinnode}{minimum number of observations in the trees terminal
nodes. Note that this is the actual number of observations not the total
weight. By default, 10 is used.}

\item{cv.fold}{integer; number of folds in the cross-validation. it is also
the number of cross-validation folds to perform within gbm. if > 1,
then apply n-fold cross validation; the default is 10, i.e., 10-fold cross
validation that is recommended.}

\item{weights}{an optional vector of weights to be used in the fitting
process. Must be positive but do not need to be normalized.
If keep.data = FALSE in the initial call to gbm then it is the user's
responsibility to resupply the weights to gbm.more. By default, a vector of
1 is used.}

\item{keep.data}{a logical variable indicating whether to keep the data and
an index of the data stored with the object. Keeping the data and index
makes subsequent calls to gbm.more faster at the cost of storing an extra
copy of the dataset. By default, 'FALSE' is used.}

\item{verbose}{If TRUE, gbm will print out progress and performance
indicators. By default, 'TRUE' is used.}

\item{nmax}{for local predicting: the number of nearest observations that
should be used for a prediction or simulation, where nearest is
defined in terms of the space of the spatial locations. By default, 12
observations are used.}

\item{vgm.args}{arguments for vgm, e.g. variogram model of response
variable and anisotropy parameters. see notes vgm in gstat for details.
By default, "Sph" is used.}

\item{block}{block size. see krige in gstat for details.}

\item{predacc}{can be either "VEcv" for vecv or "ALL" for all measures
in function pred.acc.}

\item{n.cores}{The number of CPU cores to use. See gbm for details. By
default, 6 is used.}

\item{...}{other arguments passed on to gbm.}
}
\value{
A list with the following components:
for numerical data: me, rme, mae, rmae, mse, rmse, rrmse and vecv; or vecv
for categorical data: correct classification rate (ccr.cv) and kappa (kappa.cv)
}
\description{
This function is a cross validation function for the hybrid
method of generalized boosted regression modeling and ordinary kriging.
}
\note{
this function is largely based on rf.cv (see Li et al. 2013),
rfcv in randomForest and gbm. When 'A zero or negative range was fitted to
variogram' occurs, to allow gstat running, the range was set to be positive by
using min(vgm1$dist). In this case, caution should be taken in applying this
method, although sometimes it can still outperform IDW and OK.
}
\examples{
\dontrun{
data(sponge)

gbmokcv1 <- gbmokcv(sponge[, c(1,2)], sponge[,-c(3)], sponge[, 3],
cv.fold = 10, family = "poisson", n.cores=2, predacc = "ALL")
gbmokcv1

n <- 20 # number of iterations, 60 to 100 is recommended.
VEcv <- NULL
for (i in 1:n) {
gbmokcv1 <- gbmokcv(sponge[, c(1,2)], sponge[, -c(3)], sponge[, 3],
cv.fold = 10, family = "poisson", n.cores=2, predacc = "VEcv")
VEcv [i] <- gbmokcv1
}
plot(VEcv ~ c(1:n), xlab = "Iteration for gbmok", ylab = "VEcv (\%)")
points(cumsum(VEcv) / c(1:n) ~ c(1:n), col = 2)
abline(h = mean(VEcv), col = 'blue', lwd = 2)
}

}
\references{
Li, J., J. Siwabessy, M. Tran, Z. Huang, and A. Heap. 2013.
Predicting Seabed Hardness Using Random Forest in R. Pages 299-329 in Y.
Zhao and Y. Cen, editors. Data Mining Applications with R. Elsevier.

Li, J. 2013. Predicting the spatial distribution of seabed gravel content
using random forest, spatial interpolation methods and their hybrid methods.
Pages 394-400  The International Congress on Modelling and Simulation
(MODSIM) 2013, Adelaide.

Liaw, A. and M. Wiener (2002). Classification and Regression by
randomForest. R News 2(3), 18-22.

Greg Ridgeway with contributions from others (2015). gbm: Generalized
Boosted Regression Models. R package version 2.1.1.
https://CRAN.R-project.org/package=gbm
}
\author{
Jin Li
}
