% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decimaldigit.R
\name{decimaldigit}
\alias{decimaldigit}
\title{Digit number after decimal point for a numeric variable}
\usage{
decimaldigit(x, dechar = ".", nint = NA, ndec = NA, pad.left = TRUE)
}
\arguments{
\item{x}{one or more decimal numbers.}

\item{dechar}{The character used to separate the decimal part of a number.}

\item{nint}{The number of characters to which the integer part of the numbers should be padded.}

\item{ndec}{The number of characters to which the decimal part of the numbers should be padded.}

\item{pad.left}{Whether the left (integer) side of the numbers should be padded as well as the right.}
}
\value{
A list of integer number to show digit number after decimal point of x.
}
\description{
This function is to derive the digit number after decimal point for a
numeric variable (e.g., lat and long).
}
\note{
This function is modified from decimal.align in 'prettyR' package.
}
\examples{

x<-c(0.1, 2.2, 3.03, 44.444, 555.0005, 6666.66666)
decimaldigit(x)

}
\references{
Jim Lemon and Philippe Grosjean (2019). 'prettyR': Pretty Descriptive Stats. R package version 2.1.1.
https://CRAN.R-project.org/package=prettyR.
}
\author{
Jin Li
}
