% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted.R
\name{fitted.spmod}
\alias{fitted.spmod}
\alias{fitted.values.spmod}
\title{Extract model fitted values}
\usage{
\method{fitted}{spmod}(object, type = "response", ...)

\method{fitted.values}{spmod}(object, type = "response", ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=splm]{splm()}} or \code{\link[=spautor]{spautor()}}.}

\item{type}{\code{"response"} for fitted values of the response, \code{"spcov"}
for fitted values of the spatial random errors, or \code{"randcov"} for
fitted values of the random effects. The default is \code{"response"}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
The fitted values according to \code{type}.
}
\description{
Extract fitted values from fitted model objects. \code{fitted.values}
is an alias.
}
\details{
When \code{type} is \code{"response"}, the fitted values
for each observation are the standard fitted values \eqn{X \hat{\beta}}.
When \code{type} is \code{"spcov"} the fitted values for each observation
are (generally) the best linear unbiased predictors of the spatial dependent and spatial
independent random error. When \code{type} is \code{"randcov"}, the fitted
values for each level of each random effect are (generally) the best linear unbiased
predictors of the corresponding random effect. The fitted values for \code{type}
\code{"spcov"} and \code{"randcov"} can generally be used to check assumptions
for each component of the fitted model object (e.g., check a Gaussian assumption).
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
fitted(spmod)
fitted.values(spmod)
fitted(spmod, type = "spcov")
}
