% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/map_ggplot.R
\name{map_ggplot}
\alias{map_ggplot}
\title{ggplot2 visualization of species occurences}
\usage{
map_ggplot(x, map = "world", point_color = "#86161f")
}
\arguments{
\item{x}{Input, object of class \code{occdat}}

\item{map}{(character) One of world, world2, state, usa, county, france, italy, or nz}

\item{point_color}{Default color of your points}
}
\description{
ggplot2 visualization of species occurences
}
\examples{
\dontrun{
library("spocc")
dat <- occ(query = 'Lynx rufus californicus', from = 'ecoengine', limit=100)
map_ggplot(dat)
map_ggplot(dat, "usa")
map_ggplot(dat, "county")
}
}

