% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features-lacrosse.R
\name{lacrosse_goal_line}
\alias{lacrosse_goal_line}
\title{The goal line is where the front edge of the goal sits. It spans the entire
interior dimension of the goal mouth. Its anchoring \code{x} coordinate
should be its center (e.g. half of the line's width should be on each side of
the \code{x} anchor)}
\usage{
lacrosse_goal_line(
  goal_frame_width = 0,
  line_thickness = 0,
  goal_line_full_diameter = FALSE,
  goal_circle_radius = 0
)
}
\arguments{
\item{goal_frame_width}{The interior width of the goal frame's opening}

\item{line_thickness}{The thickness of the goal line}

\item{goal_line_full_diameter}{Whether or not the goal line should extend the
full diameter of the \code{\link[=lacrosse_goal_circle]{lacrosse_goal_circle()}}}

\item{goal_circle_radius}{The outer radius of the goal circle}
}
\value{
A data frame containing the bounding coordinates of the goal line
}
\description{
The goal line is where the front edge of the goal sits. It spans the entire
interior dimension of the goal mouth. Its anchoring \code{x} coordinate
should be its center (e.g. half of the line's width should be on each side of
the \code{x} anchor)
}
\keyword{internal}
