% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features-volleyball.R
\name{volleyball_court_apron}
\alias{volleyball_court_apron}
\title{The court apron is similar to the \code{\link[=basketball_court_apron]{basketball_court_apron()}} in that it is
the area outside the court. It may be the same color as the interior of the
court, but isn't necessarily. Unlike \code{\link[=basketball_court_apron]{basketball_court_apron()}} however, the
boundary line thickness doesn't matter since the lines are considered in-play
and therefore are included in the court's length and width. This is a colored
area inside of the free zone (see \code{\link[=volleyball_free_zone]{volleyball_free_zone()}}).}
\usage{
volleyball_court_apron(
  court_length = 0,
  court_width = 0,
  court_apron_end_line = 0,
  court_apron_sideline = 0
)
}
\arguments{
\item{court_length}{The length of the court, measured from the exterior edges
of the end lines}

\item{court_width}{The width of the court, measured from the exterior edges
of the sidelines}

\item{court_apron_end_line}{The distance the court apron extends beyond the
outer edge of the end line}

\item{court_apron_sideline}{The distance the court apron extends beyond the
outer edge of the sideline}
}
\value{
A data frame containing the bounding coordinates of the court apron
}
\description{
The court apron is similar to the \code{\link[=basketball_court_apron]{basketball_court_apron()}} in that it is
the area outside the court. It may be the same color as the interior of the
court, but isn't necessarily. Unlike \code{\link[=basketball_court_apron]{basketball_court_apron()}} however, the
boundary line thickness doesn't matter since the lines are considered in-play
and therefore are included in the court's length and width. This is a colored
area inside of the free zone (see \code{\link[=volleyball_free_zone]{volleyball_free_zone()}}).
}
\keyword{internal}
