% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_track_audio_features.R
\name{get_track_audio_features}
\alias{get_track_audio_features}
\title{Get audio features from one or more tracks on Spotify}
\usage{
get_track_audio_features(tracks, access_token = get_spotify_access_token())
}
\arguments{
\item{tracks}{Dataframe containing a column `track_uri`, corresponding to Spotify Album URIs. Can be output from spotifyr::get_album_tracks or spotifyr::get_playlist_tracks()}

\item{access_token}{Spotify Web API token. Defaults to spotifyr::get_spotify_access_token()}
}
\description{
This function returns audio features from a dataframe of tracks on Spotify
}
\examples{
\dontrun{
##### Get tracks for all of Radiohead's albums
artists <- get_artists('radiohead')
albums <- get_albums(artists$artist_uri[1])
tracks <- get_album_tracks(albums)
radiohead_audio_features <- get_track_audio_features(tracks)

##### Get tracks for all of Barack Obama's playlists
playlists <- get_user_playlists('barackobama')
tracks <- get_playlist_tracks(playlists)
obama_audio_features <- get_track_audio_features(tracks)
}
}
\keyword{audio}
\keyword{features}
\keyword{track}
