% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_track_popularity.R
\name{get_track_popularity}
\alias{get_track_popularity}
\title{Get popularity of one or more tracks on Spotify}
\usage{
get_track_popularity(tracks, access_token = get_spotify_access_token())
}
\arguments{
\item{tracks}{Dataframe containing a column `track_uri`, corresponding to Spotify Album URIs. Can be output from spotifyr::get_album_tracks or spotifyr::get_playlist_tracks()}

\item{access_token}{Spotify Web API token. Defaults to spotifyr::get_spotify_access_token()}
}
\description{
This function returns the popularity of tracks on Spotify
}
\examples{
\dontrun{
artists <- get_artists('radiohead')
albums <- get_albums(artists$artist_uri[1])
tracks <- get_album_tracks(albums)
track_popularity <- get_track_popularity(tracks)
}
}
\keyword{audio}
\keyword{features}
\keyword{track}
