% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moransi.R
\name{BivariateMoransI}
\alias{BivariateMoransI}
\title{Bivariate Moran's I}
\usage{
BivariateMoransI(
  X,
  W,
  alternative = c("two.sided", "less", "greater"),
  p.adjust.method = "BH"
)
}
\arguments{
\item{X}{A matrix with observations as rows and features as columns.}

\item{W}{A weight matrix across all observations, i.e inverse of a pairwise distance matrix.}

\item{alternative}{Alternative hypothesis used, default is \code{two.sided}.}

\item{p.adjust.method}{Method used for multiple comparisons correction, default is \code{BH}. See \code{\link[stats]{p.adjust}}.}
}
\value{
A list containing the following:
\itemize{
\item Morans.I, the Moran's I.
\item Z.I, the Z score of Moran's I.
\item Expected.I, the expectation of Moran's I under the null hypothesis.
\item SD.I, the standard deviation of Moran's I under the null hypothesis.
\item alternative, alternative hypothesis used.
\item p.adjust.method, method used for multiple comparisons correction.
}
}
\description{
Calculate bivariate (multivariate) Moran's I using Wartenberg's method.
}
\examples{
{
data.use <- quakes[1:100,]
W <- 1/as.matrix(dist(data.use[,1:2]))
diag(W) <- 0
res <- BivariateMoransI(data.use[,3:4], W)
}
}
\references{
Wartenberg, D. Multivariate spatial correlation:
A method for exploratory geographical analysis. Geogr. Anal. 17, 263–283 (1985)

Czaplewski, R. L. Expected Value and Variance of Moran’s Bivariate Spatial Autocorrelation Statistic for a Permutation Test.
(U.S. Department of Agriculture, Forest Service, Rocky Mountain Forest and Range Experiment Station, 1993).
}
\concept{moransi}
