% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local.R
\name{LocalMoransI}
\alias{LocalMoransI}
\title{Local Moran's I}
\usage{
LocalMoransI(
  X,
  W,
  normalize = TRUE,
  alternative = c("two.sided", "less", "greater"),
  p.adjust.method = "BH",
  scale = TRUE
)
}
\arguments{
\item{X}{A matrix with observations as rows and features as columns.}

\item{W}{A weight matrix across all observations, i.e inverse of a pairwise distance matrix.}

\item{normalize}{Whether to normalize the weight matrix such that each row adds up to one. Default is \code{TRUE}.}

\item{alternative}{Alternative hypothesis used, default is \code{two.sided}.}

\item{p.adjust.method}{Method used for multiple comparisons correction, default is \code{BH}. See \code{\link[stats]{p.adjust}}.}

\item{scale}{Whether to scale the data. Default is \code{TRUE}.}
}
\value{
A list containing the following:
\itemize{
\item Local.Morans.I, the local Moran's I.
\item Z.I, the Z score of local Moran's I.
\item X, data matrix used for calculating local Moran's I.
\item Y, a matrix of spatial lags.
\item Expected.I, the expectation of Moran's I under the null hypothesis.
\item SD.I, the standard deviation of Moran's I under the null hypothesis.
\item p.val, p-values.
\item p.adj, adjusted p-values.
\item normalize, whether to normalize the weight matrix.
\item scale, whether to scale the data.
\item scale.factor, number of observations.
\item alternative, alternative hypothesis used.
\item p.adjust.method, method used for multiple comparisons correction.
}
}
\description{
Calculate Local Moran's I.
}
\examples{
{
data.use <- quakes[1:100,]
W <- 1/as.matrix(dist(data.use[,1:2]))
diag(W) <- 0
res <- LocalMoransI(data.use[,3:4], W)
}
}
\references{
Anselin, L. Local indicators of spatial association-LISA. Geogr. Anal. 27, 93–115 (1995)
Sokal, R. R., Oden, N. L. & Thomson, B. A. Local spatial autocorrelation in a biological model. Geogr. Anal. 30, 331–354 (1998)
}
\concept{local}
