% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_plots.R
\name{plot_runmean}
\alias{plot_runmean}
\title{Checking convergence: running means plot}
\usage{
plot_runmean(chain, open_new_window = FALSE)
}
\arguments{
\item{chain}{An \code{Lx1} vector containing the \code{L} posterior realizations.}

\item{open_new_window}{Open a new window for the plot.}
}
\description{
This function produces a running mean plot, that is,
a plot of the iterations against the mean of
the draws up to each iteration. If the plot is not a near
constant line then convergence has not been achieved (e.g., label switching is present).

For examples see

\url{http://faculty.missouri.edu/~micheasa/sppmix/sppmix_all_examples.html
#plot_runmean}
}
\examples{
\donttest{
truemix_surf <- rmixsurf(m = 3, lambda=100, xlim = c(-3,3), ylim = c(-3,3))
plot(truemix_surf)
genPPP=rsppmix(intsurf = truemix_surf, truncate = FALSE)
fit <- est_mix_damcmc(pp = genPPP, m = 3)
plot_runmean(fit$genps[,1])
plot_runmean(fit$genps[,2])
plot_runmean(fit$genps[,3])}

}
\seealso{
\code{\link{est_mix_damcmc}},
\code{\link{rmixsurf}},
\code{\link{rsppmix}}
}
\author{
Sakis Micheas
}
