% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.spqtest.R
\name{summary.spqtest}
\alias{summary.spqtest}
\title{Summary of estimated objects of class \emph{spqtest}.}
\usage{
\method{summary}{spqtest}(object, ...)
}
\arguments{
\item{object}{An \emph{spqtest} object including a list of \emph{htest}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
An object of class \emph{summary.spqtest}
}
\description{
This function summarizes estimated \emph{spqtest} objects.
  The tables in the output include basic information for each test.
  blablabla...
}
\examples{
# Example 1: With coordinates
N <- 100
cx <- runif(N)
cy <- runif(N)
coor <- cbind(cx,cy)
p <- c(1/6,3/6,2/6)
rho = 0.5
listw <- spdep::nb2listw(spdep::knn2nb(
              spdep::knearneigh(cbind(cx, cy), k = 4)))
fx <- dgp.spq(list = listw, p = p, rho = rho)
q.test <- Q.test(fx = fx, coor = coor, m = 3, r = 1)
summary(q.test)
plot(q.test)
}
\seealso{
\code{\link{print.summary.spqtest}}
}
\author{
\tabular{ll}{
  Fernando López  \tab \email{fernando.lopez@upct.es} \cr
  Román Mínguez  \tab \email{roman.minguez@uclm.es} \cr
  Antonio Páez \tab \email{paezha@gmail.com} \cr
  Manuel Ruiz \tab \email{manuel.ruiz@upct.es} \cr
  }
}
