% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsServerCollections.R
\name{loadDF}
\alias{loadDF}
\title{Load tabular files as tibbles to server}
\usage{
loadDF(
  choice,
  data_init = NULL,
  upload_path = NULL,
  eg_path = NULL,
  comment = "#",
  delim = "\\t",
  col_types = vroom::cols(),
  ...
)
}
\arguments{
\item{choice}{where this file comes from, one of 'upload' or example 'eg'?}

\item{data_init}{a tibble to return if \code{upload_path} or \code{eg_path} is not
provided. Return a 8x8 empty tibble if not provided}

\item{upload_path}{when \code{choice} is "upload", where to load the file, will
return \code{data_init} if this param is not provided}

\item{eg_path}{when \code{choice} is "eg", where to load the file, will
return \code{data_init} if this param is not provided}

\item{comment}{comment characters to parse the datafile,
see help file of \link[vroom:vroom]{vroom::vroom}}

\item{delim}{delimiter characters to parse the data file,
see help file of \link[vroom:vroom]{vroom::vroom}}

\item{col_types}{columns specifications, see help file of \link[vroom:vroom]{vroom::vroom}}

\item{...}{other params for vroom, see help file of \link[vroom:vroom]{vroom::vroom}}
}
\value{
returns a tibble and \code{NULL} if parsing fails
}
\description{
load a file to server end. It's designed to be used with a
input file source switch button.
It uses \link[vroom:vroom]{vroom::vroom} to load the file. In SPS, this
function is usually combined as downstream of  \code{\link[=dynamicFileServer]{dynamicFileServer()}}
function on on the server side to
read the file into R. This loading function only works for parsing
tabular data, use \code{\link[vroom:vroom]{vroom::vroom()}} internally.

If no user data is uploaded, it will return the example dataset that is prepared
by the developer. If the developer does not provide the dataset either,
it will return a 8-row empty tibble.
}
\details{
This is function is wrapped by the \code{\link[=shinyCatch]{shinyCatch()}} function, so it
will show loading information both on console and on UI. This function
prevents loading file errors to crash the Shiny app, so any kind of file upload will not
crash the app. To show message on UI, \code{spsDepend("toastr")} must be used in Shiny UI
function, see examples.
}
\examples{
if(interactive()){
    library(shinyWidgets)
    # change value to 'local' to see the difference
    spsOption("mode", value = "server")
    ui <- fluidPage(
        spsDepend("toastr"),
        shinyWidgets::radioGroupButtons(
            inputId = "data_source", label = "Choose your data file source:",
            selected = "upload",
            choiceNames = c("Upload", "Example"),
            choiceValues = c("upload", "eg")
        ),
        dynamicFile("data_path", label = "input file"),
        dataTableOutput("df")
    )

    server <- function(input, output, session) {
        tmp_file <- tempfile(fileext = ".csv")
        write.csv(iris, file = tmp_file)
        upload_path <- dynamicFileServer(input, session, "data_path")
        data_df <- reactive({
            loadDF(choice = input$data_source,
                   upload_path = upload_path()$datapath,
                   delim = ",", eg_path = tmp_file)
        })
        output$df <- renderDataTable(data_df())
    }
    shinyApp(ui, server)
}
}
