% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dframe.check.R
\name{dframe.check}
\alias{dframe.check}
\title{Internal Check on Survey Analysis Data Frames}
\usage{
dframe.check(sites, design, subpop, data.cat, data.cont, data.risk,
  design.names)
}
\arguments{
\item{sites}{The sites data frame.}

\item{design}{The design data frame.}

\item{subpop}{The subpop data frame.}

\item{data.cat}{The data.cat data frame of categorical response variables.}

\item{data.cont}{The data.cont data frame of continuous response variables.}

\item{data.risk}{The data.ar or data.rr data frame of categorical response
and stressor variables.}

\item{design.names}{The names for the design data frame.}
}
\value{
List consisting of the sites data frame, design data frame, subpop
  data frame, data.cat data frame, and data.cont data frame.
}
\description{
This function checks site IDs, the sites data frame, the subpop data frame,
the data.cat data frame, the data.cont data frame, the data.ar data frame,
and the data.rr data frame to assure valid contents.  If they do not exist,
then the sites data frame and the subpop data frame are created.
}
\section{Other Functions Required}{

  \describe{
    \item{\code{\link{vecprint}}}{takes an input vector and outputs a
      character string with line breaks inserted}
  }
}

\author{
Tom Kincaid \email{Kincaid.Tom@epa.gov}
}
