#' spsurvey: Spatial Survey Design and Analysis
#'
#' This package provides functions for design and analysis of probability
#' surveys.  The functions in spsurvey can select generalized random-tesselation
#' stratified (GRTS) and independent random sample (IRS) survey designs.
#' Although the function can be used with a wide range of environmental survey
#' designs, the spsurvey analysis functions were written to accommodate data
#' generated by a GRTS sampling design.  The functions in spsurvey are
#' applicable to finite (discrete units, zero-dimensional), linear
#' (one-dimensional), and areal (two-dimensional) resources.  Examples of these
#' resource are lakes in the United States (a finite resource), rivers and
#' streams in Oregon (a linear resource), and Chesapeake Bay (an areal
#' resource). The design functions can select stratified and unstratified
#' sampling designs. The analysis functions can accommodate stratified and
#' unstratified designs, both of which can utilize single-stage or two-stage
#' sampling.  Analytical capabilities accommodate both categorical and
#' continuous data.  For categorical data, estimates of proportion and size of
#' each category (class) can be obtained.  For a finite resource, size is the
#' number of units in the resource.  For an extensive (linear or areal)
#' resource, size is the measure (extent) of the resource, i.e., length, area,
#' or volume.  In addition, for categorical data that contains bivariate (two
#' categories) response variables and bivariate explanatory (stressor)
#' variables, relative risk estimates and attributable risk estimates can be
#' calculated.  For continuous data, estimates of the cumulative distribution
#' function (CDF) and percentiles can be obtained in addition to estimation of
#' the population mean, total, variance, and standard deviation. Optionally, for
#' continuous data, estimation of the deconvoluted CDF and estimation of
#' percentiles using the deconvoluted CDF are available.
#'
# Import all packages listed as Depends or Imports
#' @import methods
#' @import sf
#' @importFrom crossdes find.BIB
#' @importFrom deldir deldir tile.list
#' @importFrom foreign read.ssd read.xport
#' @importFrom graphics axis box legend lines mtext par plot points text title
#' @importFrom grDevices graphics.off pdf rainbow
#' @importFrom Hmisc describe
#' @importFrom MASS ginv
#' @importFrom parallel clusterEvalQ clusterExport detectCores getDefaultCluster
#'   makeCluster parLapply setDefaultCluster stopCluster
#' @importFrom rgeos gIntersection
#' @importFrom sp SpatialPoints SpatialPointsDataFrame
#' @importFrom stats addmargins dist dnorm ftable model.frame optimize pchisq pf
#'   pnorm qnorm rnorm runif var
#'
"_PACKAGE"
