% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbcframe.R
\name{sbcframe}
\alias{sbcframe}
\title{Calculate Spatial Balance Grid Cell Extent and Proportion for a Survey Frame}
\usage{
sbcframe(sfobject, nrows = 5, dxdy = TRUE)
}
\arguments{
\item{sfobject}{An object of class sf that contains the survey frame.}

\item{nrows}{Number of rows (and columns) for the grid of cells.  The
default is 5.}

\item{dxdy}{Indicator for equal x-coordinate and y-coordinate grid cell
increments, where TRUE means the increments are equal and FALSE means the
increments are not equal.  The default is TRUE.}
}
\value{
List containing the following components:
  \describe{
    \item{extent}{the frame extent for each grid cell}
    \item{prop}{the frame proportion for each grid cell}
    \item{xmin}{the grid x-coordinate minimum value}
    \item{xmax}{the grid x-coordinate maximum value}
    \item{ymin}{the grid y-coordinate minimum value}
    \item{ymax}{the grid y-coordinate maximum value}
    \item{dx}{the grid cell x-coordinate increment value}
    \item{dy}{the grid cell y-coordinate increment value}
    \item{xc}{the vector of grid cell x-coordinates}
    \item{yc}{the vector of grid cell y-coordinates}
  }
}
\description{
This function calculates spatial balance grid cell extent and proportion
for the sample frame.
}
\author{
Tom Kincaid \email{Kincaid.Tom@epa.gov}
}
