% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.SpatialCorrelogramModel.R
\name{plot.SpatialCorrelogramModel}
\alias{plot.SpatialCorrelogramModel}
\title{Plots correlogram model}
\usage{
\method{plot}{SpatialCorrelogramModel}(x, distance = 1, ylim = c(0, 1),
  xlab = "Distance", ylab = "Correlation", ...)
}
\arguments{
\item{x}{Object of class "SpatialCorrelogramModel" as created by makeCRM().}

\item{distance}{minimum distance between locations (unit should correspond
with the unit of the range parameter in makeCRM()).}

\item{ylim}{the y limits of the plot.}

\item{xlab}{a title for the x axis.}

\item{ylab}{a title for the y axis.}

\item{...}{additional parameters.}
}
\value{
plot of correlogram model
}
\description{
Plots correlogram model
}
\examples{

mycormodel <- makeCRM(acf0 = 0.8, range = 300, model = "Exp")
plot(mycormodel, distance = 1)

}
\author{
Kasia Sawicka, Gerard Heuvelink
}
