% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genSample.JointScalar.R
\name{genSample.JointScalar}
\alias{genSample.JointScalar}
\title{Generating sample from cross-correlated variables described by a scalar.}
\usage{
\method{genSample}{JointScalar}(UMobject, n, samplemethod, p = 0,
  asList = TRUE, ...)
}
\arguments{
\item{UMobject}{object of a class JointScalar created using defineMUM.R}

\item{n}{integer; number of Monte Carlo runs}

\item{samplemethod}{"randomSampling" or "lhs".}

\item{p}{a vector of quantiles. Optional. Only required if sample method is "lhs".}

\item{asList}{logical. If asList = TRUE returns list of all samples as a list. 
If asList = FALSE returns samples in a format of distribution parameters in UMobject.}

\item{...}{Additional parameters.}
}
\value{
Monte Carlo sample of cross-correlated scalar variables.
}
\description{
Generating sample from cross-correlated variables described by a scalar.
}
\examples{

set.seed(12345)
scalarUM <- defineUM(uncertain = TRUE, distribution = "norm",
                     distr_param = c(1, 2), id="Var1")                
scalarUM2 <- defineUM(uncertain = TRUE, distribution = "norm",
                      distr_param = c(3, 2), id="Var2")
scalarUM3 <- defineUM(uncertain = TRUE, distribution = "norm",
                      distr_param = c(10, 2.5), id="Var3")                
myMUM <- defineMUM(UMlist = list(scalarUM, scalarUM2, scalarUM3), 
               matrix(c(1,0.7,0.2,0.7,1,0.5,0.2,0.5,1), nrow = 3, ncol = 3))
my_sample <- genSample(myMUM, n = 10, samplemethod = "randomSampling", asList = FALSE)
my_sample  

}
\author{
Kasia Sawicka, Gerard Heuvelink
}
