\name{hkey}
\alias{hkey}
\alias{vkey}
\title{ Add a color key to a plot }
\description{ Add a horizontal or vertical color key to a plot }
\usage{
hkey(map, title = NA, side = 1, stretch = 1.4, x, y, skip, wh)
vkey(map, title = NA, side = 2, stretch = 1.4, x, y, skip, wh)
}
\arguments{
  \item{map}{ A list, as generated by \code{\link{makecmap}}. }
  \item{title}{ Title for the key. }
  \item{side}{ Where to place the labels. (1 or 3 for \code{hkey}, 2 or 4 for \code{vkey})  }
  \item{stretch}{ Aspect ratio of the color rectangles. }
  \item{x, y}{ Position of lower left corner of the color rectangles.  If missing, the key will be placed automatically in the lower-left (\code{hkey}) or lower-right (\code{vkey}) corner of the figure region.}
  \item{skip}{ Omit every \code{skip} labels (optional). }
  \item{wh}{ Integer indices indicating which labels to include (optional). }
}
\details{ 

This functions tries to label as many breakpoints as possible, but if the labels would overlap a subset of labels is chosen automatically. If this doesn't look right, the subset of labels can be specified with either \code{skip} or \code{wh}.

Clipping is turned off, so the key can be placed
anywhere in the figure region, including the margins.

}
\examples{ 

  attach(iris)
  map <- makecmap(Petal.Length)
  pl.color <- cmap(Petal.Length, map = map)

  plot(Sepal.Length, Sepal.Width, col = pl.color, pch = 16)
  hkey(map, title = 'Petal length (hkey default)')
  hkey(map, title = 'Another hkey', x = 3.8, y = 4.7, stretch = 3)

  ## looks bad with default margins
  vkey(map, title = 'vkey default')

  vkey(map, title = 'Small vkey', x = 7.8, y = 4, stretch = 0.3)

}
\keyword{ aplot }
\keyword{ color }
