% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qts-dist.R
\name{dist}
\alias{dist}
\alias{dist.default}
\alias{dist.qts_sample}
\title{QTS Distance Matrix Computation}
\usage{
dist(x, metric, ...)

\method{dist}{default}(
  x,
  metric = c("euclidean", "maximum", "manhattan", "canberra", "binary", "minkowski"),
  diag = FALSE,
  upper = FALSE,
  p = 2,
  ...
)

\method{dist}{qts_sample}(
  x,
  metric = c("l2", "pearson", "dtw"),
  warping_class = c("affine", "dilation", "none", "shift", "srsf"),
  cluster_on_phase = FALSE,
  labels = NULL,
  ...
)
}
\arguments{
\item{x}{A numeric matrix, data frame, \link[stats:dist]{stats::dist} object or object of
class \link{qts_sample} specifying the sample on which to compute the pairwise
distance matrix.}

\item{metric}{A character string specifying the distance measure to be used.
This must be one of \code{"euclidean"}, \code{"maximum"}, \code{"manhattan"},
\code{"canberra"}, \code{"binary"} or \code{"minkowski"} if \code{x} is not a QTS sample.
Otherwise, it must be one of \code{"l2"}, \code{"pearson"} or \code{"dtw"}.}

\item{...}{not used.}

\item{diag}{logical value indicating whether the diagonal of the
    distance matrix should be printed by \code{print.dist}.}

\item{upper}{logical value indicating whether the upper triangle of the
    distance matrix should be printed by \code{print.dist}.}

\item{p}{The power of the Minkowski distance.}

\item{warping_class}{A string specifying the warping class Choices are
\code{"affine"}, \code{"dilation"}, \code{"none"}, \code{"shift"} or \code{"srsf"}. Defaults to
\code{"affine"}. The SRSF class is the only class which is boundary-preserving.}

\item{cluster_on_phase}{A boolean specifying whether clustering should be
based on phase variation or amplitude variation. Defaults to \code{FALSE} which
implies amplitude variation.}

\item{labels}{A character vector specifying curve labels. Defaults to \code{NULL}
which uses sequential numbers as labels.}
}
\value{
An object of class \link[stats:dist]{stats::dist}.
}
\description{
This function massages an input sample of quaternion time series to turn it
into a pairwise distance matrix.
}
\examples{
D <- dist(vespa64$igp[1:5])
}
