% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qts-sample-class.R
\name{append}
\alias{append}
\alias{append.default}
\alias{append.qts_sample}
\title{QTS Sample Concatenation}
\usage{
append(x, ...)

\method{append}{default}(x, values, after = length(x), ...)

\method{append}{qts_sample}(x, y, ...)
}
\arguments{
\item{x}{Either a numeric vector or an object of class \code{\link{qts_sample}}.}

\item{...}{Extra arguments to be passed on to next methods.}

\item{values}{to be included in the modified vector.}

\item{after}{a subscript, after which the values are to be appended.}

\item{y}{Either a numeric vector or an object of class \code{\link{qts_sample}} or an
object of class \code{\link{qts}}.}
}
\value{
If \code{x} is a numeric vector, the output is a numeric vector containing
the values in \code{x} with the elements of \code{values} appended after the
specified element of \code{x}. If \code{x} is of class \code{\link{qts_sample}}, the output is
another object of class \code{\link{qts_sample}} containing the elements in \code{x} and
the ones in \code{y} appended after the last element of \code{x}.
}
\description{
QTS Sample Concatenation
}
\examples{
append(vespa64$igp, vespa64$igp[1])
append(vespa64$igp, vespa64$igp[[1]])
}
