% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile_fmsy.r
\name{profile_fmsy}
\alias{profile_fmsy}
\title{Determine Fmsy for a given operating model}
\usage{
profile_fmsy(om_in, results_out, start = 0, end = 1.5, by_val = 0.01,
  ss_mode = c("safe", "optimized"))
}
\arguments{
\item{om_in}{A directory for an \pkg{ss3sim} operating model.}

\item{results_out}{A directory to place the results}

\item{start}{Lower fishing mortality level}

\item{end}{Upper fishing mortality level}

\item{by_val}{Interval in which you wish to increment the fishing mortality
level}

\item{ss_mode}{SS3 binary option. One of \code{"safe"} for the safe version
of SS3 or \code{"optimized"} for the optimized version of SS3. The relevant
binary needs to be in your system's path. See the vignette
\code{vignette("ss3sim-vignette", package = "ss3sim")} for details and
links to the binary files. Defaults to safe mode.}
}
\value{
Creates a plot and a table with catches and F values (see the
  \code{results_out} folder). Also invisibly returns the Fmsy table as a data
  frame.
}
\description{
Runs an operating model over a range of fishing mortality levels to
determine the profile of F values from which Fmsy can be determined.
}
\details{
This function extracts the number of years from the model dat
file and then runs at a constant level of fishing for each year,
extracting the catch in the last year. This assumes the length of the
model is long enough to reach an equilibrium catch. The user is
responsible for ensuring this fact.
}
\examples{
\dontrun{
d <- system.file("extdata", package = "ss3sim")
omfolder <- paste0(d, "/models/cod-om")


fmsy.val <- profile_fmsy(om_in = omfolder, results_out = "fmsy",
  start = 0.1, end = 0.2, by_val = 0.05)
}
}

