% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_progress.R
\name{get_mut_status}
\alias{get_mut_status}
\title{Converts MAF file or data in other formats into mutation matrix.}
\usage{
get_mut_status(maf_data, nonsynonymous = TRUE, TCGA = TRUE, mut_rate = 0)
}
\arguments{
\item{maf_data}{The patients' somatic mutation data, which in MAF format or others.}

\item{nonsynonymous}{Logical. Determine if extract the non-silent somatic mutations .}

\item{TCGA}{Logical. Determine whether the file is in MAF format .}

\item{mut_rate}{Used to filter genes with target mutation rate .}
}
\value{
A binary mutations matrix, in which 1 represents that a particular gene has mutated in a particular sample, and 0 represents that gene is wild type.
}
\description{
The function `get_mut_status` is used to convert MAF file or data in other formats into a binary mutation matrix.
}
\examples{
#load the data
mut_path <- system.file("extdata","mutation_data.Rdata",package = "ssMutPA")
load(mut_path)
#perform the function `get_mut_status`.
mut_status<-get_mut_status(mutation_data,nonsynonymous=TRUE,TCGA=TRUE,mut_rate=0)
}
