% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{FastSEAscore}
\alias{FastSEAscore}
\title{Calculate the enrichment score of the pathways .}
\usage{
FastSEAscore(labels.list, correl_vector)
}
\arguments{
\item{labels.list}{The position of the genes in the pathway in the ranked gene list .}

\item{correl_vector}{A ranked list of all genes in the PPI network.}
}
\value{
Enrichment scores of pathways based on predefined gene ranked lists.
}
\description{
The function `FastSEAscore` is used to calculate the pathway enrichment score.
}
\examples{
#load the data
pathway_path<-system.file("extdata","kegg_323_gmt.Rdata",package = "ssMutPA")
load(pathway_path)
pathway_list<-split(kegg_323_gmt[,2],kegg_323_gmt[,1])
data(RWR_res)
gene_list<-sort(RWR_res,decreasing=TRUE)
tag.indicator <- sign(match(names(gene_list), pathway_list[[1]], nomatch = 0))
#perform the function `FastSEAscore`.
Path_ES<-FastSEAscore(labels.list=tag.indicator,correl_vector = gene_list)
names(Path_ES)<-names(pathway_list)[1]
}
