% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsdr.R
\name{fsdr_all}
\alias{fsdr_all}
\title{False simultaneous discovery rate control -- report all thresholds}
\usage{
fsdr_all(T1, T2, alpha, m1 = 5000, m2 = 5000)
}
\arguments{
\item{T1, T2}{paired vectors of test statistics, both must be the same length; must be stochastically larger under the alternative than under the null; must contain only positive values}

\item{alpha}{desired false simultaneous discovery rate}

\item{m1, m2}{search only up the m1th (m2th) most significant test statistic in T1 (T2)}
}
\value{
k x 2 matrix, where k is the number of rectangular regions found; the first column is the threshold for T1 and the second column is for T2
}
\description{
Given two sequences of paired test statistics, returns all rectangular rejections that identify the largest number of simultaneous signals while also controlling the false discovery rate.
}
\examples{
\donttest{
## generate paired test statistics
p <- 10^6; ## total number of pairs
X <- c(rep(0,p-30),rep(1,10),rep(2,10),rep(3,10));
## X=0: no signal in either sequence of tests
## X=1: signal in sequence 1 only
## X=2: signal in sequence 2 only
## X=3: simultaneous signal
set.seed(1);
Z1 <- rnorm(p,0,1); Z1[X==1|X==3] <- rnorm(20,3,1);
Z2 <- rnorm(p,0,1); Z2[X==2|X==3] <- rnorm(20,4,1);
## all rectangular rejection regions
out.zz <- fsdr_all(abs(Z1),abs(Z2),alpha=0.05,m1=1000,m2=1000);
## 10 sets of identified simultaneous signals
R <- apply(out.zz[1:10,],1,function(x){
             which(abs(Z1)>=x[1]&abs(Z2)>=x[2]);
           });
}

}

