% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BaseClassifier.R
\name{bClassif}
\alias{bClassif}
\title{Base Classifier Specification}
\usage{
bClassif(train, predClass, predProb, ...)
}
\arguments{
\item{train}{a function to train a supervised classifier.
This function should return the model trained.
For usage information see Details.}

\item{predClass}{a function to predict the class of
instances, using the model trained with \code{train}.
This function should return a vector with the predicted classes.
For usage information see Details.}

\item{predProb}{a function to predict the probabilities per class
of instances, using the model trained with \code{train}.
This function should return a matrix with the predicted
probabilities. The matrix, should have:
the number of rows equal to the size of prediction set and
the number of columns equal to the number of possible classes.
For usage information see Details.}

\item{...}{additional arguments passed to \code{train}.}
}
\value{
The classifier specification stored in a list of class \code{bClassif}.
}
\description{
This function defines a supervised classifier specification
with the format expected by the semi-supervised classifiers in this package.
}
\details{
The \code{train} function is used as follows:

\code{model  <-  train(m,  y,  ...)}

The training data is provided in the two first arguments. Here, \code{m}
is a distance matrix between the training instances and \code{y} is a vector
with the classes of those instances. Additional arguments of the classifier can
be passed to \code{train} through the additional arguments (\code{...})
specified in \code{bClassif}.

The \code{predClass} and \code{predProb} functions are used as follows:

\code{cls  <-  predClass(model, pm)} \cr
\code{cls  <-  predProb(model, pm)}

In both cases, the prediction data is supplied using \code{pm}.
\code{pm} is a distance matrix with the following dimensions:
the number of rows equal to the size of the prediction set and the number
of columns equal to the size of the training set. \code{predClass} returns
a vector with the predicted classes and \code{predProb} returns a matrix
that contains the class probabilities. In this matrix, there is a column
for each class and a row for each instance.
}

