% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reordering.R
\name{conditionalReordering}
\alias{conditionalReordering}
\title{Conditional Reordering}
\usage{
conditionalReordering(n, list.correlation.matrix, name,
  scenario.probability = NULL, region.boundaries = NULL,
  region.probability = NULL, keep.realized.scenario = F)
}
\arguments{
\item{n}{positive numeric value of length one. The number of ranks to produce (equal to the number
of simulations of the model).}

\item{list.correlation.matrix}{list of correlation matrices, the correlation matrix
corresponding to the base normal copula should be provided as a named member "base" in the
list (and in first position). the rest of the scenarios should be named in the list by a unique identifier that
should match the column names of the argument \code{region.boundaries}. Please consider that if no
scenario correlation matrices are provided, then simple reordering with the "base" correlation matrix is
undertaken (note also that in this case, we require \code{scenario.probability}, \code{region.boundaries} and
\code{region.probability} to be \code{NULL}).}

\item{name}{character value of length between 0 and 4. It should indicate the names of
the subset of risks among:
\itemize{
  \item market
  \item life
  \item health
  \item nonlife
}
that are aggregated together with the reordering algorithm. The order of risks in this vector
should respect the order defined in the correlation matrices in \code{list.correlation.matrix}.}

\item{scenario.probability}{numeric value giving the scenario probabilities (these probabilities should
be provided in the same order as the the order of scenarios in \code{list.correlation.matrix} (following the
correlation matrix named "base").}

\item{region.boundaries}{matrix with named columns and rows giving the thresholds
for each regions (boundaries of the scenario rectangles). Each line represents a given scenario and each column a given quantity
to reorder. The rownames should match the scenario names and the colnames should match the
risks respecting the order prescribed in both \code{name} and the colnames of each correlation
matrix in \code{list.correlation.matrix}.}

\item{region.probability}{numeric vector giving the probability under the base Gaussian
copula (characterized by the correlation matrix named "base") to hit the scenario regions given by each
line in regions.boundary.}

\item{keep.realized.scenario}{logical value. Should we keep the realized scenario for each line?}
}
\value{
a \code{data.table} with the final ranks (between 0 and 1) with which we should reorder the given simulations.
}
\description{
function to generate ranks that have been simply reordered with a Gaussian copula or
  conditionally reordered with Gaussian copula stressed scenarios from a base Gaussian copula.
}
