% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributionFuns.R
\name{skewed_t_dens}
\alias{skewed_t_dens}
\title{The density function of the univariate skewed t distribution}
\usage{
skewed_t_dens(y, nu, lambda)
}
\arguments{
\item{y}{a numeric vector containing the values at which the density is to be evaluated.}

\item{nu}{the degrees of freedom parameter value, a numeric scalar strictly larger than two.}

\item{lambda}{the skewness parameter value, a numeric scalar strictly between -1 and 1.}
}
\value{
Returns a numeric vector of the same length as \code{y} containing the density values.
}
\description{
\code{skewed_t_dens} calculates the density of the univariate skewed t distribution described in Hansen (1994).
}
\details{
See Hansen (1994, Section 2.4) for the details of the skewed t distribution.
}
\references{
\itemize{
   \item Hansen B.E. 1994. Autoregressive Conditional Density estimation. \emph{Journal of Econometrics}, \strong{35}:3, 705-730.
 }
}
\keyword{internal}
