% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STVARconstruction.R
\name{stvar_to_sstvars110}
\alias{stvar_to_sstvars110}
\title{Update STVAR model estimated with a version of the package <1.1.0 to
  be compatible with the versions >=1.1.0.}
\usage{
stvar_to_sstvars110(stvar)
}
\arguments{
\item{stvar}{object of class \code{"stvar"}}
}
\value{
Returns an object of class \code{'stvar'} with the elements \code{$penalized},
 \code{$penalty_params}, and \code{$allow_unstab} added to it if they were missing.
}
\description{
\code{update_stvar_to_sstvar110} updates a STVAR model estimated with a version of
  the package <1.1.0 to be compatible with the versions >=1.1.0 by adding the elements
  \code{$penalized}, \code{$penalty_params}, and \code{$allow_unstab} to the model object.
}
\details{
The function is useful when a STVAR model estimated with a version of the package <1.1.0.
  Does not do anything if the elements \code{$penalized}, \code{$penalty_params}, and \code{$allow_unstab}
  are already containing in the model object.
}
\examples{
# Linear Gaussian VAR(p=1) model:
theta_112 <- c(0.649526, 0.066507, 0.288526, 0.021767, -0.144024, 0.897103,
  0.601786, -0.002945, 0.067224)
mod112 <- STVAR(data=gdpdef, p=1, M=1, params=theta_112)

# Update to include the new elements (does not do anything if they are already
# included):
mod112 <- stvar_to_sstvars110(mod112)
}
