% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parafac_functions.R
\name{parafac_conv}
\alias{parafac_conv}
\title{Calculate a PARAFAC model similar to and using \code{\link[multiway]{parafac}}.}
\usage{
parafac_conv(
  X,
  nstart,
  verbose = FALSE,
  output = c("best", "all"),
  cl = NULL,
  ...
)
}
\arguments{
\item{X}{array}

\item{nstart}{number of converging models to calculate}

\item{verbose}{logical, whether more information is supplied}

\item{output}{Output the best solution (default) or output all nstart solutions.}

\item{cl}{cluster to be used for parallel processing}

\item{...}{arguments passed on to \code{\link[multiway]{parafac}}}
}
\value{
either a parafac model or a list of parafac models
}
\description{
Please refer to \code{\link[multiway]{parafac}} for input parameters and details. This wrapper function ensures `nstart` converging models are calculated. On the contrary, parafac calculates `nstart` models regardless if they are converging.
}
\examples{
\donttest{
data(eem_list)

dim_min <- 3 # minimum number of components
dim_max <- 4 # maximum number of components
nstart <- 25 # random starts for PARAFAC analysis, models built simulanuously, best selected
# cores <- parallel::detectCores(logical=FALSE) # use all cores but do not use all threads
cores <- 2 # package checks only run with 2 cores
maxit = 2500
ctol <- 10^-7 # tolerance for parafac

pfres_comps <- eem_parafac(eem_list, comps = seq(dim_min, dim_max),
    normalise = TRUE, strictly_converging = TRUE, maxit = maxit, nstart = nstart,
    ctol = ctol, cores = cores)

# keep all calculated models for diagnostics
pfres_comps_all <- eem_parafac(eem_list, comps = seq(dim_min, dim_max),
    normalise = TRUE, strictly_converging = TRUE, output = "all", maxit = maxit,
    nstart = nstart, ctol = ctol, cores = cores)

}
}
\seealso{
\code{\link[multiway]{parafac}}
}
