% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correction_functions.R
\name{eem_matmult}
\alias{eem_matmult}
\title{Multiply all EEMs with a matrix}
\usage{
eem_matmult(eem_list, matrix = NULL, value = 0)
}
\arguments{
\item{eem_list}{EEM data as eemlist}

\item{matrix}{either a vactor containing "l" and/or "u" or a matrix, see details.}

\item{value}{in case matrices "l" or "u" are used, this specifies the value to use in this areas. Usually this is 0 (default) or NA but any numeric value can be used.}
}
\value{
eemlist
}
\description{
Multiply all EEMs with a matrix
}
\details{
All EEMs must be of the same size. If matrix is of type matrix, it is used right away to multiply the EEMs. It has to be of the same size as the EEMs. If matrix is a vector containing "l", values below 1st order Rayleigh scattering are set to 0. If matrix contains "u", values above 2nd order Raman scattering are set to 0. If you want to remove wavelength ranges, take into consideration to use \code{\link[eemR]{eem_cut}} or \code{\link[staRdom]{eem_range}}.
}
\examples{
\donttest{
data(eem_list)
eem <- eem_list[1:9]
class(eem) <- "eemlist"

ggeem(eem)

eem_list_cut <- eem_matmult(eem,matrix=c("l"), value= NA)
ggeem(eem_list_cut)
}
}
