% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial.R
\name{partial}
\alias{partial}
\title{Partially apply a function}
\usage{
partial(f, ...)
}
\arguments{
\item{f}{a function}

\item{...}{arguments to capture}
}
\description{
Simplify a function by setting some arguments to pre-specified values
}
\examples{
# Example 1:
f <- function(a, b, c, d) a+b+c+d
p <- partial(f, a=2, c=3)
p(b=0, d=1)

# captures a format string for printing out sleep data
labeller <- partial(sprintf, fmt="extra=\%3.2f, group=\%d, ID=\%d")
do.call(labeller, sleep[1, , drop=FALSE])

}
\references{
\url{http://stackoverflow.com/questions/32173901/how-to-efficiently-partially-apply-a-function-in-r}
}
\seealso{
\code{\link[pryr]{partial}}

\code{\link[functional]{Curry}}
}
\author{
\href{http://stackoverflow.com/users/3093387/josilber}{John Silberholz},
}
