% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1b-base-model-function.R
\name{getstagepath}
\alias{getstagepath}
\alias{get_stage}
\alias{get_path}
\title{Retrieve stage or path}
\usage{
get_stage(object, path)

get_path(object, var, stage)
}
\arguments{
\item{object}{a staged event tree object}

\item{path}{a vector contating the path from root or
a two dimensional array where each row is a path
from root}

\item{var}{string, one of the variable in
the staged tree}

\item{stage}{string or vector, the name
of the stages for which the paths should be
returned}
}
\value{
\code{get_stage} returns
the name of the stage for a given path (or paths).

\code{get_paths} return a
data.frame containing the paths
corresponding to the given stage (or stages).
}
\description{
Utility functions to obtain stages from paths and
paths from stages.
}
\examples{
model <- fbhc.sevt(full(PhDArticles))
get_stage(model, c("0", "male"))
paths <- expand.grid(model$tree[2:1])[,2:1]
get_stage(model, paths)

get_path(model, "Kids", "11")
get_path(model, "Gender", "2")
get_path(model, "Kids", c("5", "6"))
}
