% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/9-search-order.R
\name{search_best}
\alias{search_best}
\title{Optimal Order Search}
\usage{
search_best(
  data,
  alg = stages_bhc,
  search_criterion = BIC,
  lambda = 0,
  join_unobserved = TRUE,
  ...
)
}
\arguments{
\item{data}{either a data.frame or a table containing the data.}

\item{alg}{a function that performs stages structure estimation. Similar to
\code{\link{stages_bhc}} or \code{\link{stages_hclust}}.
The function \code{alg} must accept the argument
\code{scope}.}

\item{search_criterion}{the criterion minimized in the order search.}

\item{lambda}{numerical value passed to \code{\link{full}}.}

\item{join_unobserved}{logical, passed to \code{\link{full}}.}

\item{...}{additional arguments, passed to \code{alg}.}
}
\value{
The estimated staged event tree model.
}
\description{
Find the optimal staged event tree
with a dynamic programming approach.
}
\details{
This function is an implementation of the
dynamic programming approach
of Silander and Leong (2013).
If the \code{search_criterion} is decomposable
the returned model attains the best value
among all possible orders.
}
\examples{
## default search using BIC score
model <- search_best(Titanic, alg = stages_kmeans)

## use df as search_criterion
model1 <- search_best(Titanic, alg = stages_bhc, 
                      search_criterion = function(m) attr(logLik(m), "df"))
}
\references{
Silander T., Leong TY.
A Dynamic Programming Algorithm for Learning Chain Event Graphs.
In: Fürnkranz J., Hüllermeier E., Higuchi T. (eds)
Discovery Science. DS 2013. \emph{Lecture Notes in Computer Science},
vol 8140. Springer, Berlin, Heidelberg. 2013.

Cowell R and Smith J.
Causal discovery through MAP selection of stratified chain event graphs.
\emph{Electronic Journal of Statistics}, 8(1):965–997, 2014.
}
