% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stamp.stgroup.summary.r
\name{stamp.stgroup.summary}
\alias{stamp.stgroup.summary}
\title{Compile stamp summary statistics by space-time group}
\usage{
stamp.stgroup.summary(stmp, area = TRUE, count = TRUE)
}
\arguments{
\item{stmp}{a \code{SpatialPolygonsDataFrame} generated from the \code{stamp} function.}

\item{area}{logical, whether or not to compute the STAMP event areas.}

\item{count}{logical, whether or not to compute the count of STAMP evets within each group.}
}
\value{
A \code{data.frame} where rows are stamp groups and columns correspond to the STAMP event types (ID, areas, and counts).
}
\description{
The function \code{stamp.stgroup.summary} compiles summary statistics for each STAMP grouping.
 Specifically, it computes the area of each STAMP event type (e.g., generation, expansion, etc.)
 within each grouping. It also computes the number of events belonging to each event type.
}
\details{
\code{stamp.group.summary} computes area and count summary statistics of STAMP output. Note that if
 both \code{area} and \code{count} are set to \code{FALSE}, \code{stamp.group.summary} returns a
 \code{data.frame} with just the stgroup IDs as the only column.
}
\examples{
library(sp)
data("katrina")
katrina$ID <- katrina$Id
ch <- stamp.multichange(katrina, changeByRow = TRUE, dc = 0, distance = TRUE, direction = FALSE)
STGroup <- stamp.stgroup.summary(ch)
head(STGroup)

}
\keyword{stamp}

