% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PMXStanFit.R
\name{rsd.vs.pred}
\alias{rsd.vs.pred}
\title{Pointwise comparison between residuals vs. predicted medians.}
\usage{
rsd.vs.pred(fit, ...)
}
\arguments{
\item{fit}{a \code{PMXStanFit} object.}

\item{...}{additional arguments.}
}
\description{
Plots lots residuals, calculated as the difference between medians of predictions and observations, 
vs. predictions. This function is a generic version of the method \code{plot.gof.pred.rsd()} for the 
\code{\link{PMXStanFit}} class.
}
\value{No return value, called for side effects}
\examples{
\dontrun{
m1 <- PMXStanModel(path = tempfile("pk_m1"), pk.struct = "1-cmpt", compile=TRUE)

data("examples_data")
dat <- prepareInputData(data.source = d1_nm_poppk, model = m1)

fit <- PMXStanFit(m1, dat, iter=100, chains=1)

obs.vs.pred(fit, by.cov = "GENDER", type = "categorical", filename = "obs_pred_by_gender.pdf")
rsd.vs.pred(fit, by.cov = "GENDER", type = "categorical", filename = "gof_by_gender.pdf")
}
}
\seealso{
\code{\link{PMXStanFit}} for the methods \code{plot.gof.pred.rsd()}.
}

