% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta.R
\name{read_stars_meta}
\alias{read_stars_meta}
\title{read raster/array metadata from file(s) or connection}
\usage{
read_stars_meta(.x, ..., options = character(0), driver = character(0),
  sub = TRUE, NA_value = NA_real_)
}
\arguments{
\item{.x}{if character, name of file(s) to read; if list: list with arrays}

\item{...}{ignored}

\item{options}{character; opening options}

\item{driver}{character; driver to use for opening file}

\item{sub}{integer or logical; sub-datasets to be read}

\item{NA_value}{numeric value to be used for conversion into NA values; by default this is read from the input file}
}
\value{
if \code{.x} has length 1 and no subdatasets, object of class \code{stars_meta}, otherwise a list of \code{stars_meta} objects, or a list of lists of those (with first level nesting: elements of \code{.x}, second level: subdatasets)
}
\description{
read raster/array metadata from file(s) or connection
}
\examples{
tif = system.file("tif/L7_ETMs.tif", package = "stars")
x = read_stars(tif)
# x1 = read_stars(nv, options = "OVERVIEW_LEVEL=1")
}
