% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mosaic.R
\name{st_mosaic}
\alias{st_mosaic}
\alias{st_mosaic.stars}
\alias{st_mosaic.character}
\title{build mosaic (composite) of several spatially disjoint stars objects}
\usage{
st_mosaic(.x, ...)

\method{st_mosaic}{stars}(
  .x,
  ...,
  dst = tempfile(fileext = file_ext),
  options = c("-vrtnodata", "-9999"),
  file_ext = ".tif"
)

\method{st_mosaic}{character}(
  .x,
  ...,
  dst = tempfile(fileext = file_ext),
  options = c("-vrtnodata", "-9999"),
  file_ext = ".tif"
)
}
\arguments{
\item{.x}{object of class stars, or character vector with input dataset names}

\item{...}{further input stars objects}

\item{dst}{character; destination file name}

\item{options}{character; options to the gdalbuildvrt command}

\item{file_ext}{character; file extension, determining the format used to write to (".tif" implies GeoTIFF)}
}
\value{
the stars method returns a stars object with the composite of the input; the \code{character} method returns the file name of the file with the mosaic; see also the GDAL documentation of \code{gdalbuildvrt}
}
\description{
build mosaic (composite) of several spatially disjoint stars objects
}
\details{
the gdal function buildvrt builds a mosaic of input images; these imput images can be multi-band, but not higher-dimensional data cubes or stars objects with multiple attributes

uses \link[sf]{gdal_utils} to internally call \code{buildvrt}; no executables external to R are called.
}
\examples{
x = read_stars(system.file("tif/L7_ETMs.tif", package = "stars"))
x1 = x[,100:200,100:200,]
x2 = x[,150:300,150:300,]
plot(st_mosaic(x1, x2))
}
