% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer_to_matrix.R
\name{layer_to_matrix}
\alias{layer_to_matrix}
\title{Get \code{stars} layer values as matrix}
\usage{
layer_to_matrix(x, check = TRUE)
}
\arguments{
\item{x}{A \code{stars} raster with one attribute and two dimensions, \code{x} and \code{y}, i.e., a single-band raster.}

\item{check}{Whether to check (and fix if necessary) that input has one attribute, one layer and x-y as dimensions 1-2 (default is \code{TRUE}).}
}
\value{
A \code{matrix} with the layer values, having the same orientation as the raster (i.e., rows represent the y-axis and columns represent the x-axis).
}
\description{
Extracts the values of a single layer in a \code{stars} object to a \code{matrix}.
}
\examples{
data(dem)
m = layer_to_matrix(dem)
m

}
