% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record_update_set_update_selection_general.R
\name{update_selection_general}
\alias{update_selection_general}
\alias{update_selection_general.record_update_set}
\title{Update dimension records with a set of values in given columns}
\usage{
update_selection_general(
  updates = NULL,
  dimension,
  columns_old = vector(),
  old_values = vector(),
  columns_new = vector(),
  new_values = vector()
)

\method{update_selection_general}{record_update_set}(
  updates = NULL,
  dimension,
  columns_old = vector(),
  old_values = vector(),
  columns_new = vector(),
  new_values = vector()
)
}
\arguments{
\item{updates}{A \code{record_update_set} object.}

\item{dimension}{A \code{dimension_table} object, dimension to update.}

\item{columns_old}{A vector of column names.}

\item{old_values}{A vector of character values.}

\item{columns_new}{A vector of column names.}

\item{new_values}{A vector of character values.}
}
\value{
A \code{record_update_set} object.
}
\description{
For a dimension, given a vector of column names, a vector of old values for
those columns, another vector column names, and a vector of new values for
those columns, it adds an update to the set of updates that modifies all the
records that have the combination of old values in the first column vector
with the new values in the second column vector.
}
\examples{

dim_names <- st_mrs_age |>
    get_dimension_names()

where <- st_mrs_age |>
  get_dimension("where")

# head(where, 2)

updates <- record_update_set() |>
  update_selection_general(
    dimension = where,
    columns_old = c("state", "city"),
    old_values = c("CT", "Bridgepor"),
    columns_new = c("city"),
    new_values = c("Bridgeport")
  )

}
\seealso{
Other data cleaning functions: 
\code{\link{get_conformed_dimension_names}()},
\code{\link{get_conformed_dimension}()},
\code{\link{get_dimension_names}()},
\code{\link{get_dimension}()},
\code{\link{match_records}()},
\code{\link{modify_conformed_dimension_records}()},
\code{\link{modify_dimension_records}()},
\code{\link{record_update_set}()},
\code{\link{update_record}()},
\code{\link{update_selection}()}
}
\concept{data cleaning functions}
