% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phase2_memory.R
\name{panel_handles}
\alias{panel_handles}
\title{Create a space time visualization of data handles}
\usage{
panel_handles(
  data,
  JobId = NA,
  lines = NA,
  lHandle = NA,
  name_func = NULL,
  legend = data$config$handles$legend,
  base_size = data$config$base_size,
  expand_x = data$config$expand,
  x_start = data$config$limits$start,
  x_end = data$config$limits$end
)
}
\arguments{
\item{data}{starvz_data with trace data}

\item{JobId}{Select handles of jobid}

\item{lines}{vertical lines}

\item{lHandle}{select handles}

\item{name_func}{function to give names to handles}

\item{legend}{enable/disable legends}

\item{base_size}{base_size base font size}

\item{expand_x}{expand size for scale_x_continuous padding}

\item{x_start}{X-axis start value}

\item{x_end}{X-axis end value}
}
\value{
A ggplot object
}
\description{
Visualizate data handles movement
To accelerate the process:\preformatted{
data$handle_states <- handles_presence_states(data)
data$handle_gantt_data <- pre_handle_gantt(data)
To Select time:
handles_gantt(data, JobId=c(jobid))
snap_data <- pre_snap(data, data$handle_states)
memory_snap(snap_data, 1000, tasks_size=200, step=1)}
}
\examples{
\donttest{
panel_handles(data = starvz_sample_lu)
}
}
