% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statGraph.R
\name{gCEM}
\alias{gCEM}
\title{Clustering Expectation-Maximization for Graphs (gCEM)}
\usage{
gCEM(g, model, num_clusters, max_iter = 1000, ncores = 1)
}
\arguments{
\item{g}{a list containing the adjacency matrix of the graphs to be
clustered.}

\item{model}{a string that indicates one of the following random graph
models: "ER" (Erdos-Renyi random graph), "GRG" (geometric random graph), "KR"
(k regular graph), "WS" (Watts-Strogatz model), and "BA" (Barabasi-Albert
model).}

\item{num_clusters}{an integer specifying the number of clusters.}

\item{max_iter}{the number of expectation-maximization steps to execute. The default value is 1000.}

\item{ncores}{the number of cores used in the parallel processing. The
default value is 1.}
}
\value{
a vector containing two fields:
labels a vector of the same length of g containing the clusterization labels;
p a vector of length equals to num_clusters.
}
\description{
\code{gCEM} clusters graphs following an expectation-maximization algorithm
based on the Kullback-Leibler divergence between the spectral densities of
the graph and of the random graph model.
}
\examples{
g <- list()
for(i in 1:1){
  g[[i]] <- igraph::get.adjacency(igraph::sample_smallworld(dim=1, size=5, nei=2 ,p=0))
}
for(i in 2:2){
  g[[i]] <- igraph::get.adjacency(igraph::sample_smallworld(dim=1, size= 5, nei=2 ,p=1))
}
res <- gCEM(g, model="WS", num_clusters=2,max_iter = 1, ncores=2)
res

}
\references{
Celeux, Gilles, and Govaert, Gerard. "Gaussian parsimonious clustering
models." Pattern recognition 28.5 (1995): 781-793.
}
\keyword{gCEM}
