% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statGraph.R
\name{sp.anogva}
\alias{sp.anogva}
\title{Semi-Parametric Analysis Of Graph Variability (ANOGVA)}
\usage{
sp.anogva(
  graph,
  model,
  maxBoot = 500,
  spectra = NULL,
  eps = 0.01,
  classic = FALSE
)
}
\arguments{
\item{graph}{a list of adjacency (symmetric) matrices of the undirected
graphs to be compared. For unweighted graphs, each matrix contains only 0s
and 1s. For weighted graphs, each matrix contains real values that correspond
to the weights of the edges.}

\item{model}{A string that indicates one of the following models: "ER"
(Erdos-Renyi random graph model), "GRG" (geometric random graph model), "WS"
(Watts-Strogatz random graph model), and "BA" (Barabasi-Albert random graph
model).}

\item{maxBoot}{integer indicating the number of bootstrap resamples (default
is 500).}

\item{spectra}{optional parameter containing the precomputed spectrum of the
model. It is a three-dimensional array in which the first dimension
corresponds to all parameters that will be explored in the parameter
estimation, the second dimension has the same size of the given graph, and
the third one corresponds to graphs randomly generated by the model. Thus,
the position (i,j,k) contains the j-th eigenvalue of the k-th graph generated
with the i-th parameter. The attribute 'rownames' of the array corresponds to
the parameters converted to string. If spectra is NULL (default), then
model' is used to generate random graphs and their spectra are computed
automatically.}

\item{eps}{(default is 0.01) precision of the grid when 'classic' = TRUE.}

\item{classic}{logical. If FALSE (default) parameter is estimated using
ternary search, if TRUE parameter is estimated using grid search.}
}
\value{
A list containing:
\item{parameter}{an array containing the estimated parameters for each
graph.}
\item{F.value}{the F statistic of the test.}
\item{p.value}{the p-value of the test.}
}
\description{
\code{sp.anogva} statistically tests whether two or more graphs are
generated by the same model and set of parameters.
}
\examples{

## Please uncomment the following lines to run an example
# require(igraph)
# set.seed(42)
# model <- "ER"
# graph <- list()

## Under H0
# graph[[1]] <- get.adjacency(erdos.renyi.game(50, 0.5))
# graph[[2]] <- get.adjacency(erdos.renyi.game(50, 0.5))
# graph[[3]] <- get.adjacency(erdos.renyi.game(50, 0.5))
# result <- sp.anogva(graph, model, maxBoot = 300)
# result

## Under H1
# graph[[1]] <- get.adjacency(erdos.renyi.game(50, 0.5))
# graph[[2]] <- get.adjacency(erdos.renyi.game(50, 0.55))
# graph[[3]] <- get.adjacency(erdos.renyi.game(50, 0.5))
# result <- sp.anogva(graph, model, maxBoot = 300)
# result

}
\references{
Andre Fujita, Eduardo Silva Lira, Suzana de Siqueira Santos, Silvia Yumi
Bando, Gabriela Eleuterio Soares, Daniel Yasumasa Takahashi. A
semi-parametric statistical test to compare complex networks, Journal of
Complex Networks, cnz028, https://doi.org/10.1093/comnet/cnz028
}
\keyword{semi_parametric_analysis_of_graph_variability}
