% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/pastem.R
\name{pastem}
\alias{evalm}
\alias{pastem}
\alias{pastem0}
\alias{quotem}
\alias{quotem_}
\title{String and expression interpolation}
\usage{
pastem(..., sep = " ", pattern = "$", parenthesis.only = FALSE,
  env = parent.frame(), inherits = FALSE)

pastem0(..., env = parent.frame())

evalm(x, pattern = "$", parenthesis.only = FALSE, env = parent.frame(),
  inherits = FALSE)

quotem(x, pattern = "$", parenthesis.only = FALSE, env = parent.frame(),
  inherits = FALSE)

quotem_(x, pattern = "$", parenthesis.only = FALSE, env = parent.frame(),
  inherits = FALSE)
}
\arguments{
\item{...}{Paste multiple strings}

\item{sep}{a character string to separate the terms.}

\item{pattern}{pattern to use. Default to \code{$}}

\item{parenthesis.only}{Limit patterns within parenthesis?}

\item{env}{environment in which to evalute the expressions enclosed in patterns. Default to current environement}

\item{inherits}{Default to FALSE}

\item{x}{any syntactically valid R expression}
}
\value{
The functions \code{pastem} does string interpolations.
The functions \code{quotem} does expression interpolations. It is very similar to `substitute` except that (i) it works in the global environment (ii) only variables prefixed with a pattern are substituted (iii) LHS of `=` is also substituted.
The function \code{evalm} is a wapper for \code{eval(quotem()))}.

The expressions includes all letters + underscore that follow the pattern. Use parenthesis if you want the expression to be shorter or longer.
Expressions that follow the pattern are evaluated in the environment specified by \code{env} and substituted into the original object. When they are the name of a non existent object, nothing is returned. Note that in the expression \code{list(`$ok`="`$ok`")}, both occurences are substituted by the object to which \code{ok} refers to.
}
\description{
String and expression interpolation
}
\details{
The functions replaces expressions starting with the \code{pattern} by evaluating them in the environment specified by \code{env} (susbtituting by nothing if not found)
}
\examples{
height <- 72
units <- "inches"
weight <- 230
a <- "ght"
pastem("My record indicates you are $height $(units).")
pastem("Your body mass index is $(round(703*weight/height^2))")
pastem("My record indicates you are $(hei$a) inches tall")
pastem("You are .(height) inches tall.This is below average", pattern = ".")
a <- ".This"
pastem("You are .(height) inches tall.a is below average", pattern = ".")
library(data.table)
N <- 100
DT <- data.table(
  id = sample(5, N, TRUE),
  v1 = sample(5, N, TRUE),
  v2 = sample(1e6, N, TRUE)
)
newvar <- quote(temp)
myvar <- quote(v1)
byvar <- c("id", "v1")
quotem(DT[, list(`$newvar` = mean(`$myvar`)), by = `$byvar`])
evalm(DT[, list(`$newvar` = mean(`$myvar`)), by = `$byvar`])
}

