/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import blbutil.SampleFileIt;
import haplotype.HapPair;
import haplotype.SampleHapPairs;
import java.util.ArrayList;
import java.util.List;
import vcf.BasicGL;
import vcf.Data;
import vcf.GL;
import vcf.Marker;
import vcf.Markers;
import vcf.VcfEmission;
import vcf.VcfWindow;

public class TargetData
implements Data {
    private final VcfWindow vcfWindow;
    private int window = 0;
    private Markers markers;
    private VcfEmission[] markerData;
    private GL gl;

    public static TargetData targetData(SampleFileIt<? extends VcfEmission> sampleFileIt) {
        if (sampleFileIt.samples().nSamples() == 0) {
            throw new IllegalArgumentException("nSamples==0");
        }
        return new TargetData(new VcfWindow(sampleFileIt));
    }

    private TargetData(VcfWindow vcfWindow) {
        this.vcfWindow = vcfWindow;
        this.markers = Markers.create(new Marker[0]);
        this.markerData = new VcfEmission[0];
        this.gl = new BasicGL(vcfWindow.samples(), this.markerData);
    }

    @Override
    public boolean lastWindowOnChrom() {
        return this.vcfWindow.lastWindowOnChrom();
    }

    @Override
    public boolean canAdvanceWindow() {
        return this.vcfWindow.canAdvanceWindow();
    }

    @Override
    public void advanceWindow(int n, int n2) {
        this.markerData = this.vcfWindow.advanceWindow(n, n2);
        this.markers = TargetData.extractMarkers(this.markerData);
        this.gl = new BasicGL(this.vcfWindow.samples(), this.markerData);
        ++this.window;
    }

    private static Markers extractMarkers(VcfEmission[] vcfEmissionArray) {
        Marker[] markerArray = new Marker[vcfEmissionArray.length];
        for (int i = 0; i < markerArray.length; ++i) {
            markerArray[i] = vcfEmissionArray[i].marker();
        }
        return Markers.create(markerArray);
    }

    @Override
    public int window() {
        return this.window;
    }

    @Override
    public int targetOverlap() {
        return this.vcfWindow.overlap();
    }

    @Override
    public int overlap() {
        return this.vcfWindow.overlap();
    }

    @Override
    public int nTargetMarkers() {
        return this.markers.nMarkers();
    }

    @Override
    public int nTargetMarkersSoFar() {
        return this.vcfWindow.cumMarkerCnt();
    }

    @Override
    public Markers targetMarkers() {
        return this.markers;
    }

    @Override
    public int nMarkers() {
        return this.markers.nMarkers();
    }

    @Override
    public int nMarkersSoFar() {
        return this.vcfWindow.cumMarkerCnt();
    }

    @Override
    public Markers markers() {
        return this.markers;
    }

    @Override
    public int targetMarkerIndex(int n) {
        if (n < 0 || n >= this.markers.nMarkers()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return n;
    }

    @Override
    public int markerIndex(int n) {
        if (n < 0 || n >= this.markers.nMarkers()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return n;
    }

    @Override
    public int nTargetSamples() {
        return this.vcfWindow.nSamples();
    }

    @Override
    public Samples targetSamples() {
        return this.vcfWindow.samples();
    }

    @Override
    public int nRefSamples() {
        return 0;
    }

    @Override
    public Samples refSamples() {
        return null;
    }

    @Override
    public int nAllSamples() {
        return this.nTargetSamples();
    }

    @Override
    public Samples allSamples() {
        return this.targetSamples();
    }

    @Override
    public GL targetGL() {
        return this.gl;
    }

    @Override
    public List<HapPair> restrictedRefHapPairs() {
        return new ArrayList<HapPair>();
    }

    @Override
    public List<HapPair> refHapPairs() {
        return new ArrayList<HapPair>();
    }

    @Override
    public SampleHapPairs refSampleHapPairs() {
        return null;
    }

    @Override
    public void close() {
        this.vcfWindow.close();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("vcf.NonRefData");
        return stringBuilder.toString();
    }
}

