% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getProbs.R
\name{getProbs}
\alias{getProbs}
\title{Extract Probabilities for markers}
\usage{
getProbs(IBDprob, markers, sumProbs = FALSE)
}
\arguments{
\item{IBDprob}{An object of class \code{IBDprob}.}

\item{markers}{A character vector of markers that should be extracted.}

\item{sumProbs}{Should the probabilities by summed per parent. If \code{TRUE}
the probability for e.g. parent A in a cross with parent B will be calculated
as pA + 0.5 * pAB. If \code{FALSE} both pA and pAB will be output without
further calculations.}
}
\value{
A data.frame with IBD probabilities for the extracted markers in the
column and genotypes in the rows.
}
\description{
Extract IBD probabilities for one or more markers from an object of class
\code{IBDprob}.
}
\examples{
## Compute IBD probabilities for Steptoe Morex.
SxMIBD <- calcIBD(popType = "DH",
                  markerFile = system.file("extdata/SxM", "SxM_geno.txt",
                                        package = "statgenIBD"),
                  mapFile = system.file("extdata/SxM", "SxM_map.txt",
                                        package = "statgenIBD"))

## Get probabilities for a single marker.
probOne <- getProbs(IBDprob = SxMIBD,
                    markers = "plc")
head(probOne)

## Get probabilities for a multiple markers.
probMult <- getProbs(IBDprob = SxMIBD,
                     markers = c("plc", "tuba1"))
head(probMult)

}
