% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{calcIBD}
\alias{calcIBD}
\title{Calculate IBD probabilities}
\usage{
calcIBD(
  popType,
  markerFile,
  mapFile,
  evalPos = NULL,
  evalDist = NULL,
  grid = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{popType}{A character string indicating the type of population. One of
DH, Fx, FxDH, BCx, BCxDH, BC1Sx, BC1SxDH, C3, C3DH, C3Sx, C3SxDH, C4, C4DH,
C4Sx, C4SxDH (see Details).}

\item{markerFile}{A character string indicating the location of the file with
genotypic information for the population. The file should be in
tab-delimited format with a header containing marker names.}

\item{mapFile}{A character string indicating the location of the map file
for the population. The file should be in tab-delimited format. It should
consist of exactly three columns, marker, chromosome and position. There
should be no header. The positions in the file should be in centimorgan.}

\item{evalPos}{A data.frame with evaluation positions to which the
calculations should be limited.}

\item{evalDist}{An optional numerical value indicating the maximum
distance for marker positions. Extra markers will be added based on the
value of \code{grid}.}

\item{grid}{Should the extra markers that are added to assure the a
maximum distince of \code{evalDist} be on a grid (\code{TRUE}) or in between
marker existing marker positions (\code{FALSE}).}

\item{verbose}{Should messages indicating the progress of the process be
printed?}
}
\value{
An object of class \code{IBDprob}, a \code{list} with five elements,
\describe{
\item{map}{a \code{data.frame} with chromosome and position of the markers.}
\item{markers}{a 3-dimensional \code{array} of IBD probabilities with
genotypes, markers and parents as array dimensions.}
\item{parents}{the parents.}
\item{popType}{the population type.}
}
}
\description{
Calculate IBD probabilities for different types of populations.
}
\details{
IBD probabilities can be calculated for many different types of populations.
In the following table all supported populations are listed. Note that the
value of x in the population types is variable, with its maximum value
depicted in the last column.\tabular{llll}{
   \strong{Population type} \tab \strong{Cross} \tab \strong{Description} \tab \strong{max. x} \cr
   DH \tab biparental \tab doubled haploid population \tab  \cr
   Fx \tab biparental \tab Fx population (F1, followed by x-1 generations of selfing) \tab 8 \cr
   FxDH \tab biparental \tab Fx, followed by DH generation \tab 8 \cr
   BCx \tab biparental \tab backcross, second parent is recurrent parent \tab 9 \cr
   BCxDH \tab biparental \tab BCx, followed by DH generation \tab 9 \cr
   BC1Sx \tab biparental \tab BC1, followed by x generations of selfing \tab 7 \cr
   BC1SxDH \tab biparental \tab BC1, followed by x generations of selfing and DH \tab 6 \cr
   C3 \tab three-way \tab three way cross: (AxB) x C \tab  \cr
   C3DH \tab three-way \tab C3, followed by DH generation \tab  \cr
   C3Sx \tab three-way \tab C3, followed by x generations of selfing \tab 7 \cr
   C3SxDH \tab three-way \tab C3, followed by x generations of selfing and DH generation \tab 6 \cr
   C4 \tab four-way \tab four-way cross: (AxB) x (CxD) \tab  \cr
   C4DH \tab four-way \tab C4, followed by DH generation \tab  \cr
   C4Sx \tab four-way \tab C4, followed by x generations of selfing \tab 6 \cr
   C4SxDH \tab four-way \tab C4, followed by x generations of selfing and DH generation \tab 6 \cr
}
}
\examples{
## Compute IBD probabilities for Steptoe Morex.
SxMIBD <- calcIBD(popType = "DH",
                  markerFile = system.file("extdata/SxM", "SxM_geno.txt",
                                        package = "statgenIBD"),
                  mapFile = system.file("extdata/SxM", "SxM_map.txt",
                                        package = "statgenIBD"))

## Check summary.
summary(SxMIBD)

## Compute IBD probabilities for Steptoe Morex.
## Add extra evaluation positions in between exiting marker positions
## to assure evaluation positions are at most 5 cM apart.
SxMIBD_Ext <- calcIBD(popType = "DH",
                      markerFile = system.file("extdata/SxM", "SxM_geno.txt",
                                              package = "statgenIBD"),
                      mapFile = system.file("extdata/SxM", "SxM_map.txt",
                                            package = "statgenIBD"),
                      evalDist = 5)

## Check summary.
summary(SxMIBD_Ext)

}
