% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.ratio.mad2}
\alias{ci.ratio.mad2}
\title{Confidence interval for a 2-group MAD ratio}
\usage{
ci.ratio.mad2(alpha, y1, y2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y1}{vector of scores for group 1}

\item{y2}{vector of scores for group 2}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item MAD1 - estimated MAD from group 1
\item MAD2 - estimated MAD from group 2
\item MAD1/MAD2 - estimate of MAD ratio
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a ratio of population MADs (mean absolute
deviation from median) in a 2-group design.
}
\examples{
y1 <- c(32, 39, 26, 35, 43, 27, 40, 37, 34, 29)
y2 <- c(36, 44, 47, 42, 49, 39, 46, 31, 33, 48)
ci.ratio.mad2(.05, y1, y2)

# Should return:
#          MAD1     MAD2  MAD1/MAD2        LL       UL
# [1,] 5.111111 5.888889  0.8679245 0.4520879 1.666253


}
\references{
\insertRef{Bonett2003b}{statpsych}
}
