% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{test.anova1.bs}
\alias{test.anova1.bs}
\title{Between-subjects F statistic and eta-squared from summary information}
\usage{
test.anova1.bs(m, sd, n)
}
\arguments{
\item{m}{vector of sample means}

\item{sd}{vector of sample standard deviations}

\item{n}{vector of sample sizes}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item F - F statistic for test of null hypothesis
\item dfA - degrees of freedom for between-subjects factor
\item dfE - error degrees of freedom
\item dfA - degrees of freedom for between-subjects factor
\item p - p-value for F-test
\item eta-squared - estimate of eta-squared
\item adj eta-squared - a bias adjusted estimate of eta-squared
}
}
\description{
Computes the F statistic, p-value, eta-squared, and adjusted eta-squared
for the main effect of Factor A in a one-way between-subjects ANOVA using
the sample means, sample standard deviations, and sample sizes.
}
\examples{
m <- c(12.4, 8.6, 10.5)
sd <- c(3.84, 3.12, 3.48)
n <- c(20, 20, 20)
test.anova1.bs(m, sd, n)

#  Should return:
#             F dfA  dfE           p eta-squared adj eta-squared
# [1,] 5.919585   2   57 0.004614428   0.1719831       0.1429298
 

}
